/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.math;

import icyllis.modernui.math.MathUtil;
import icyllis.modernui.math.Matrix3;
import icyllis.modernui.math.Quaternion;
import icyllis.modernui.math.Vector3;
import icyllis.modernui.math.Vector4;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Matrix4
implements Cloneable {
    protected float m11;
    protected float m12;
    protected float m13;
    protected float m14;
    protected float m21;
    protected float m22;
    protected float m23;
    protected float m24;
    protected float m31;
    protected float m32;
    protected float m33;
    protected float m34;
    protected float m41;
    protected float m42;
    protected float m43;
    protected float m44;

    public Matrix4() {
    }

    public Matrix4(float ... arr) {
        this.set(arr);
    }

    @Nonnull
    public static Matrix4 copy(@Nullable Matrix4 mat) {
        return mat == null ? new Matrix4() : mat.copy();
    }

    @Nonnull
    public static Matrix4 identity() {
        Matrix4 mat = new Matrix4();
        mat.m44 = 1.0f;
        mat.m33 = 1.0f;
        mat.m22 = 1.0f;
        mat.m11 = 1.0f;
        return mat;
    }

    @Nonnull
    public static Matrix4 makeOrthographic(float left, float right, float bottom, float top, float near, float far) {
        Matrix4 mat = new Matrix4();
        float invRL = 1.0f / (right - left);
        float invTB = 1.0f / (top - bottom);
        float invNF = 1.0f / (near - far);
        mat.m11 = 2.0f * invRL;
        mat.m22 = 2.0f * invTB;
        mat.m33 = 2.0f * invNF;
        mat.m41 = -(right + left) * invRL;
        mat.m42 = -(top + bottom) * invTB;
        mat.m43 = (near + far) * invNF;
        mat.m44 = 1.0f;
        return mat;
    }

    @Nonnull
    public static Matrix4 makeOrthographic(float width, float height, float near, float far) {
        Matrix4 mat = new Matrix4();
        float invNF = 1.0f / (near - far);
        mat.m11 = 2.0f / width;
        mat.m22 = 2.0f / height;
        mat.m33 = 2.0f * invNF;
        mat.m41 = -1.0f;
        mat.m42 = -1.0f;
        mat.m43 = (near + far) * invNF;
        mat.m44 = 1.0f;
        return mat;
    }

    @Nonnull
    public static Matrix4 makePerspective(float left, float right, float bottom, float top, float near, float far) {
        Matrix4 mat = new Matrix4();
        float invRL = 1.0f / (right - left);
        float invTB = 1.0f / (top - bottom);
        float invNF = 1.0f / (near - far);
        float tNear = 2.0f * near;
        mat.m11 = tNear * invRL;
        mat.m22 = tNear * invTB;
        mat.m31 = (right + left) * invRL;
        mat.m32 = (top + bottom) * invTB;
        mat.m33 = (near + far) * invNF;
        mat.m34 = -1.0f;
        mat.m43 = tNear * far * invNF;
        return mat;
    }

    @Nonnull
    public static Matrix4 makePerspective(float fov, float aspect, float near, float far) {
        Matrix4 mat = new Matrix4();
        float y = 1.0f / MathUtil.tan(fov * 0.5f);
        float invNF = 1.0f / (near - far);
        mat.m11 = y / aspect;
        mat.m22 = y;
        mat.m33 = (near + far) * invNF;
        mat.m34 = -1.0f;
        mat.m43 = 2.0f * far * near * invNF;
        return mat;
    }

    public void add(@Nonnull Matrix4 other) {
        this.m11 += other.m11;
        this.m12 += other.m12;
        this.m13 += other.m13;
        this.m14 += other.m14;
        this.m21 += other.m21;
        this.m22 += other.m22;
        this.m23 += other.m23;
        this.m24 += other.m24;
        this.m31 += other.m31;
        this.m32 += other.m32;
        this.m33 += other.m33;
        this.m34 += other.m34;
        this.m41 += other.m41;
        this.m42 += other.m42;
        this.m43 += other.m43;
        this.m44 += other.m44;
    }

    public void subtract(@Nonnull Matrix4 other) {
        this.m11 -= other.m11;
        this.m12 -= other.m12;
        this.m13 -= other.m13;
        this.m14 -= other.m14;
        this.m21 -= other.m21;
        this.m22 -= other.m22;
        this.m23 -= other.m23;
        this.m24 -= other.m24;
        this.m31 -= other.m31;
        this.m32 -= other.m32;
        this.m33 -= other.m33;
        this.m34 -= other.m34;
        this.m41 -= other.m41;
        this.m42 -= other.m42;
        this.m43 -= other.m43;
        this.m44 -= other.m44;
    }

    public void multiply(float s2) {
        if (s2 == 1.0f) {
            return;
        }
        this.m11 *= s2;
        this.m12 *= s2;
        this.m13 *= s2;
        this.m14 *= s2;
        this.m21 *= s2;
        this.m22 *= s2;
        this.m23 *= s2;
        this.m24 *= s2;
        this.m31 *= s2;
        this.m32 *= s2;
        this.m33 *= s2;
        this.m34 *= s2;
        this.m41 *= s2;
        this.m42 *= s2;
        this.m43 *= s2;
        this.m44 *= s2;
    }

    public void multiply(@Nonnull Matrix3 mat) {
        if (mat.isIdentity()) {
            return;
        }
        float f11 = mat.m11 * this.m11 + mat.m12 * this.m21 + mat.m13 * this.m31;
        float f12 = mat.m11 * this.m12 + mat.m12 * this.m22 + mat.m13 * this.m32;
        float f13 = mat.m11 * this.m13 + mat.m12 * this.m23 + mat.m13 * this.m33;
        float f14 = mat.m11 * this.m14 + mat.m12 * this.m24 + mat.m13 * this.m34;
        float f21 = mat.m21 * this.m11 + mat.m22 * this.m21 + mat.m23 * this.m31;
        float f22 = mat.m21 * this.m12 + mat.m22 * this.m22 + mat.m23 * this.m32;
        float f23 = mat.m21 * this.m13 + mat.m22 * this.m23 + mat.m23 * this.m33;
        float f24 = mat.m21 * this.m14 + mat.m22 * this.m24 + mat.m23 * this.m34;
        float f31 = mat.m31 * this.m11 + mat.m32 * this.m21 + mat.m33 * this.m31;
        float f32 = mat.m31 * this.m12 + mat.m32 * this.m22 + mat.m33 * this.m32;
        float f33 = mat.m31 * this.m13 + mat.m32 * this.m23 + mat.m33 * this.m33;
        float f34 = mat.m31 * this.m14 + mat.m32 * this.m24 + mat.m33 * this.m34;
        this.m11 = f11;
        this.m12 = f12;
        this.m13 = f13;
        this.m14 = f14;
        this.m21 = f21;
        this.m22 = f22;
        this.m23 = f23;
        this.m24 = f24;
        this.m31 = f31;
        this.m32 = f32;
        this.m33 = f33;
        this.m34 = f34;
    }

    public void postMultiply(@Nonnull Matrix3 mat) {
        if (mat.isIdentity()) {
            return;
        }
        float f1 = this.m11 * mat.m11 + this.m12 * mat.m21 + this.m13 * mat.m31;
        float f2 = this.m11 * mat.m12 + this.m12 * mat.m22 + this.m13 * mat.m32;
        float f3 = this.m11 * mat.m13 + this.m12 * mat.m23 + this.m13 * mat.m33;
        this.m11 = f1;
        this.m12 = f2;
        this.m13 = f3;
        f1 = this.m21 * mat.m11 + this.m22 * mat.m21 + this.m23 * mat.m31;
        f2 = this.m21 * mat.m12 + this.m22 * mat.m22 + this.m23 * mat.m32;
        f3 = this.m21 * mat.m13 + this.m22 * mat.m23 + this.m23 * mat.m33;
        this.m21 = f1;
        this.m22 = f2;
        this.m23 = f3;
        f1 = this.m31 * mat.m11 + this.m32 * mat.m21 + this.m33 * mat.m31;
        f2 = this.m31 * mat.m12 + this.m32 * mat.m22 + this.m33 * mat.m32;
        f3 = this.m31 * mat.m13 + this.m32 * mat.m23 + this.m33 * mat.m33;
        this.m31 = f1;
        this.m32 = f2;
        this.m33 = f3;
        f1 = this.m41 * mat.m11 + this.m42 * mat.m21 + this.m43 * mat.m31;
        f2 = this.m41 * mat.m12 + this.m42 * mat.m22 + this.m43 * mat.m32;
        f3 = this.m41 * mat.m13 + this.m42 * mat.m23 + this.m43 * mat.m33;
        this.m41 = f1;
        this.m42 = f2;
        this.m43 = f3;
    }

    public void multiply(@Nonnull Matrix4 mat) {
        if (mat.isIdentity()) {
            return;
        }
        float f11 = mat.m11 * this.m11 + mat.m12 * this.m21 + mat.m13 * this.m31 + mat.m14 * this.m41;
        float f12 = mat.m11 * this.m12 + mat.m12 * this.m22 + mat.m13 * this.m32 + mat.m14 * this.m42;
        float f13 = mat.m11 * this.m13 + mat.m12 * this.m23 + mat.m13 * this.m33 + mat.m14 * this.m43;
        float f14 = mat.m11 * this.m14 + mat.m12 * this.m24 + mat.m13 * this.m34 + mat.m14 * this.m44;
        float f21 = mat.m21 * this.m11 + mat.m22 * this.m21 + mat.m23 * this.m31 + mat.m24 * this.m41;
        float f22 = mat.m21 * this.m12 + mat.m22 * this.m22 + mat.m23 * this.m32 + mat.m24 * this.m42;
        float f23 = mat.m21 * this.m13 + mat.m22 * this.m23 + mat.m23 * this.m33 + mat.m24 * this.m43;
        float f24 = mat.m21 * this.m14 + mat.m22 * this.m24 + mat.m23 * this.m34 + mat.m24 * this.m44;
        float f31 = mat.m31 * this.m11 + mat.m32 * this.m21 + mat.m33 * this.m31 + mat.m34 * this.m41;
        float f32 = mat.m31 * this.m12 + mat.m32 * this.m22 + mat.m33 * this.m32 + mat.m34 * this.m42;
        float f33 = mat.m31 * this.m13 + mat.m32 * this.m23 + mat.m33 * this.m33 + mat.m34 * this.m43;
        float f34 = mat.m31 * this.m14 + mat.m32 * this.m24 + mat.m33 * this.m34 + mat.m34 * this.m44;
        float f41 = mat.m41 * this.m11 + mat.m42 * this.m21 + mat.m43 * this.m31 + mat.m44 * this.m41;
        float f42 = mat.m41 * this.m12 + mat.m42 * this.m22 + mat.m43 * this.m32 + mat.m44 * this.m42;
        float f43 = mat.m41 * this.m13 + mat.m42 * this.m23 + mat.m43 * this.m33 + mat.m44 * this.m43;
        float f44 = mat.m41 * this.m14 + mat.m42 * this.m24 + mat.m43 * this.m34 + mat.m44 * this.m44;
        this.m11 = f11;
        this.m12 = f12;
        this.m13 = f13;
        this.m14 = f14;
        this.m21 = f21;
        this.m22 = f22;
        this.m23 = f23;
        this.m24 = f24;
        this.m31 = f31;
        this.m32 = f32;
        this.m33 = f33;
        this.m34 = f34;
        this.m41 = f41;
        this.m42 = f42;
        this.m43 = f43;
        this.m44 = f44;
    }

    public void postMultiply(@Nonnull Matrix4 mat) {
        if (mat.isIdentity()) {
            return;
        }
        if (this == mat) {
            this.multiply(this);
            return;
        }
        float f1 = this.m11 * mat.m11 + this.m12 * mat.m21 + this.m13 * mat.m31 + this.m14 * mat.m41;
        float f2 = this.m11 * mat.m12 + this.m12 * mat.m22 + this.m13 * mat.m32 + this.m14 * mat.m42;
        float f3 = this.m11 * mat.m13 + this.m12 * mat.m23 + this.m13 * mat.m33 + this.m14 * mat.m43;
        float f4 = this.m11 * mat.m14 + this.m12 * mat.m24 + this.m13 * mat.m34 + this.m14 * mat.m44;
        this.m11 = f1;
        this.m12 = f2;
        this.m13 = f3;
        this.m14 = f4;
        f1 = this.m21 * mat.m11 + this.m22 * mat.m21 + this.m23 * mat.m31 + this.m24 * mat.m41;
        f2 = this.m21 * mat.m12 + this.m22 * mat.m22 + this.m23 * mat.m32 + this.m24 * mat.m42;
        f3 = this.m21 * mat.m13 + this.m22 * mat.m23 + this.m23 * mat.m33 + this.m24 * mat.m43;
        f4 = this.m21 * mat.m14 + this.m22 * mat.m24 + this.m23 * mat.m34 + this.m24 * mat.m44;
        this.m21 = f1;
        this.m22 = f2;
        this.m23 = f3;
        this.m24 = f4;
        f1 = this.m31 * mat.m11 + this.m32 * mat.m21 + this.m33 * mat.m31 + this.m34 * mat.m41;
        f2 = this.m31 * mat.m12 + this.m32 * mat.m22 + this.m33 * mat.m32 + this.m34 * mat.m42;
        f3 = this.m31 * mat.m13 + this.m32 * mat.m23 + this.m33 * mat.m33 + this.m34 * mat.m43;
        f4 = this.m31 * mat.m14 + this.m32 * mat.m24 + this.m33 * mat.m34 + this.m34 * mat.m44;
        this.m31 = f1;
        this.m32 = f2;
        this.m33 = f3;
        this.m34 = f4;
        f1 = this.m41 * mat.m11 + this.m42 * mat.m21 + this.m43 * mat.m31 + this.m44 * mat.m41;
        f2 = this.m41 * mat.m12 + this.m42 * mat.m22 + this.m43 * mat.m32 + this.m44 * mat.m42;
        f3 = this.m41 * mat.m13 + this.m42 * mat.m23 + this.m43 * mat.m33 + this.m44 * mat.m43;
        f4 = this.m41 * mat.m14 + this.m42 * mat.m24 + this.m43 * mat.m34 + this.m44 * mat.m44;
        this.m41 = f1;
        this.m42 = f2;
        this.m43 = f3;
        this.m44 = f4;
    }

    public void setZero() {
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m14 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        this.m23 = 0.0f;
        this.m24 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 0.0f;
        this.m34 = 0.0f;
        this.m41 = 0.0f;
        this.m42 = 0.0f;
        this.m43 = 0.0f;
        this.m44 = 0.0f;
    }

    public void setIdentity() {
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m14 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m24 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        this.m34 = 0.0f;
        this.m41 = 0.0f;
        this.m42 = 0.0f;
        this.m43 = 0.0f;
        this.m44 = 1.0f;
    }

    public void set(@Nonnull float[] arr) {
        if (arr.length < 16) {
            throw new IllegalArgumentException("The array length must be at least 16");
        }
        this.m11 = arr[0];
        this.m12 = arr[1];
        this.m13 = arr[2];
        this.m14 = arr[3];
        this.m21 = arr[4];
        this.m22 = arr[5];
        this.m23 = arr[6];
        this.m24 = arr[7];
        this.m31 = arr[8];
        this.m32 = arr[9];
        this.m33 = arr[10];
        this.m34 = arr[11];
        this.m41 = arr[12];
        this.m42 = arr[13];
        this.m43 = arr[14];
        this.m44 = arr[15];
    }

    public void set(@Nonnull Matrix4 mat) {
        this.m11 = mat.m11;
        this.m12 = mat.m12;
        this.m13 = mat.m13;
        this.m14 = mat.m14;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
        this.m23 = mat.m23;
        this.m24 = mat.m24;
        this.m31 = mat.m31;
        this.m32 = mat.m32;
        this.m33 = mat.m33;
        this.m34 = mat.m34;
        this.m41 = mat.m41;
        this.m42 = mat.m42;
        this.m43 = mat.m43;
        this.m44 = mat.m44;
    }

    public void put(@Nonnull float[] arr) {
        if (arr.length < 16) {
            throw new IllegalArgumentException("The array length must be at least 16");
        }
        arr[0] = this.m11;
        arr[1] = this.m12;
        arr[2] = this.m13;
        arr[3] = this.m14;
        arr[4] = this.m21;
        arr[5] = this.m22;
        arr[6] = this.m23;
        arr[7] = this.m24;
        arr[8] = this.m31;
        arr[9] = this.m32;
        arr[10] = this.m33;
        arr[11] = this.m34;
        arr[12] = this.m41;
        arr[13] = this.m42;
        arr[14] = this.m43;
        arr[15] = this.m44;
    }

    public float determinant() {
        return (this.m11 * this.m22 - this.m12 * this.m21) * (this.m33 * this.m44 - this.m34 * this.m43) - (this.m11 * this.m23 - this.m13 * this.m21) * (this.m32 * this.m44 - this.m34 * this.m42) + (this.m11 * this.m24 - this.m14 * this.m21) * (this.m32 * this.m43 - this.m33 * this.m42) + (this.m12 * this.m23 - this.m13 * this.m22) * (this.m31 * this.m44 - this.m34 * this.m41) - (this.m12 * this.m24 - this.m14 * this.m22) * (this.m31 * this.m43 - this.m33 * this.m41) + (this.m13 * this.m24 - this.m14 * this.m23) * (this.m31 * this.m42 - this.m32 * this.m41);
    }

    public float trace() {
        return this.m11 + this.m22 + this.m33 + this.m44;
    }

    public void transpose() {
        float t = this.m21;
        this.m21 = this.m12;
        this.m12 = t;
        t = this.m31;
        this.m31 = this.m13;
        this.m13 = t;
        t = this.m32;
        this.m32 = this.m23;
        this.m23 = t;
        t = this.m41;
        this.m41 = this.m14;
        this.m14 = t;
        t = this.m42;
        this.m42 = this.m24;
        this.m24 = t;
        t = this.m43;
        this.m43 = this.m34;
        this.m34 = t;
    }

    public void adjugate() {
        float det12 = this.m11 * this.m22 - this.m12 * this.m21;
        float det13 = this.m11 * this.m23 - this.m13 * this.m21;
        float det14 = this.m11 * this.m24 - this.m14 * this.m21;
        float det23 = this.m12 * this.m23 - this.m13 * this.m22;
        float det24 = this.m12 * this.m24 - this.m14 * this.m22;
        float det34 = this.m13 * this.m24 - this.m14 * this.m23;
        float f31 = this.m42 * det34 - this.m43 * det24 + this.m44 * det23;
        float f32 = -this.m41 * det34 + this.m43 * det14 - this.m44 * det13;
        float f33 = this.m41 * det24 - this.m42 * det14 + this.m44 * det12;
        float f34 = -this.m41 * det23 + this.m42 * det13 - this.m43 * det12;
        float f41 = -this.m32 * det34 + this.m33 * det24 - this.m34 * det23;
        float f42 = this.m31 * det34 - this.m33 * det14 + this.m34 * det13;
        float f43 = -this.m31 * det24 + this.m32 * det14 - this.m34 * det12;
        float f44 = this.m31 * det23 - this.m32 * det13 + this.m33 * det12;
        det12 = this.m31 * this.m42 - this.m32 * this.m41;
        det13 = this.m31 * this.m43 - this.m33 * this.m41;
        det14 = this.m31 * this.m44 - this.m34 * this.m41;
        det23 = this.m32 * this.m43 - this.m33 * this.m42;
        det24 = this.m32 * this.m44 - this.m34 * this.m42;
        det34 = this.m33 * this.m44 - this.m34 * this.m43;
        float f11 = this.m22 * det34 - this.m23 * det24 + this.m24 * det23;
        float f12 = -this.m21 * det34 + this.m23 * det14 - this.m24 * det13;
        float f13 = this.m21 * det24 - this.m22 * det14 + this.m24 * det12;
        float f14 = -this.m21 * det23 + this.m22 * det13 - this.m23 * det12;
        float f21 = -this.m12 * det34 + this.m13 * det24 - this.m14 * det23;
        float f22 = this.m11 * det34 - this.m13 * det14 + this.m14 * det13;
        float f23 = -this.m11 * det24 + this.m12 * det14 - this.m14 * det12;
        float f24 = this.m11 * det23 - this.m12 * det13 + this.m13 * det12;
        this.m11 = f11;
        this.m21 = f12;
        this.m31 = f13;
        this.m41 = f14;
        this.m12 = f21;
        this.m22 = f22;
        this.m32 = f23;
        this.m42 = f24;
        this.m13 = f31;
        this.m23 = f32;
        this.m33 = f33;
        this.m43 = f34;
        this.m14 = f41;
        this.m24 = f42;
        this.m34 = f43;
        this.m44 = f44;
    }

    public boolean inverse() {
        float det1_12 = this.m11 * this.m22 - this.m12 * this.m21;
        float det3_34 = this.m33 * this.m44 - this.m34 * this.m43;
        float det1_13 = this.m11 * this.m23 - this.m13 * this.m21;
        float det3_24 = this.m32 * this.m44 - this.m34 * this.m42;
        float det1_14 = this.m11 * this.m24 - this.m14 * this.m21;
        float det3_23 = this.m32 * this.m43 - this.m33 * this.m42;
        float det1_23 = this.m12 * this.m23 - this.m13 * this.m22;
        float det3_14 = this.m31 * this.m44 - this.m34 * this.m41;
        float det1_24 = this.m12 * this.m24 - this.m14 * this.m22;
        float det3_13 = this.m31 * this.m43 - this.m33 * this.m41;
        float det1_34 = this.m13 * this.m24 - this.m14 * this.m23;
        float det3_12 = this.m31 * this.m42 - this.m32 * this.m41;
        float det = det1_12 * det3_34 - det1_13 * det3_24 + det1_14 * det3_23 + det1_23 * det3_14 - det1_24 * det3_13 + det1_34 * det3_12;
        if (MathUtil.approxZero(det)) {
            return false;
        }
        float f31 = this.m42 * det1_34 - this.m43 * det1_24 + this.m44 * det1_23;
        float f32 = -this.m41 * det1_34 + this.m43 * det1_14 - this.m44 * det1_13;
        float f33 = this.m41 * det1_24 - this.m42 * det1_14 + this.m44 * det1_12;
        float f34 = -this.m41 * det1_23 + this.m42 * det1_13 - this.m43 * det1_12;
        float f41 = -this.m32 * det1_34 + this.m33 * det1_24 - this.m34 * det1_23;
        float f42 = this.m31 * det1_34 - this.m33 * det1_14 + this.m34 * det1_13;
        float f43 = -this.m31 * det1_24 + this.m32 * det1_14 - this.m34 * det1_12;
        float f44 = this.m31 * det1_23 - this.m32 * det1_13 + this.m33 * det1_12;
        float f11 = this.m22 * det3_34 - this.m23 * det3_24 + this.m24 * det3_23;
        float f12 = -this.m21 * det3_34 + this.m23 * det3_14 - this.m24 * det3_13;
        float f13 = this.m21 * det3_24 - this.m22 * det3_14 + this.m24 * det3_12;
        float f14 = -this.m21 * det3_23 + this.m22 * det3_13 - this.m23 * det3_12;
        float f21 = -this.m12 * det3_34 + this.m13 * det3_24 - this.m14 * det3_23;
        float f22 = this.m11 * det3_34 - this.m13 * det3_14 + this.m14 * det3_13;
        float f23 = -this.m11 * det3_24 + this.m12 * det3_14 - this.m14 * det3_12;
        float f24 = this.m11 * det3_23 - this.m12 * det3_13 + this.m13 * det3_12;
        this.m11 = f11;
        this.m21 = f12;
        this.m31 = f13;
        this.m41 = f14;
        this.m12 = f21;
        this.m22 = f22;
        this.m32 = f23;
        this.m42 = f24;
        this.m13 = f31;
        this.m23 = f32;
        this.m33 = f33;
        this.m43 = f34;
        this.m14 = f41;
        this.m24 = f42;
        this.m34 = f43;
        this.m44 = f44;
        if (!MathUtil.approxEqual(det, 1.0f)) {
            this.multiply(1.0f / det);
        }
        return true;
    }

    public boolean invertible() {
        return !MathUtil.approxZero(this.determinant());
    }

    public void translate(@Nonnull Vector3 t) {
        this.translate(t.x, t.y, t.z);
    }

    public void translate(float tx, float ty, float tz) {
        this.m41 += tx;
        this.m42 += ty;
        this.m43 += tz;
    }

    public void setToTranslation(@Nonnull Vector3 t) {
        this.setToTranslation(t.x, t.y, t.z);
    }

    public void setToTranslation(float x, float y, float z) {
        this.setIdentity();
        this.m41 = x;
        this.m42 = y;
        this.m43 = z;
    }

    public void scaleX(float s2) {
        this.m11 *= s2;
        this.m12 *= s2;
        this.m13 *= s2;
        this.m14 *= s2;
    }

    public void scaleY(float s2) {
        this.m21 *= s2;
        this.m22 *= s2;
        this.m23 *= s2;
        this.m24 *= s2;
    }

    public void scaleZ(float s2) {
        this.m31 *= s2;
        this.m32 *= s2;
        this.m33 *= s2;
        this.m34 *= s2;
    }

    public void scale(@Nonnull Vector3 s2) {
        this.scale(s2.x, s2.y, s2.z);
    }

    public void scale(float sx, float sy, float sz) {
        this.m11 *= sx;
        this.m12 *= sx;
        this.m13 *= sx;
        this.m14 *= sx;
        this.m21 *= sy;
        this.m22 *= sy;
        this.m23 *= sy;
        this.m24 *= sy;
        this.m31 *= sz;
        this.m32 *= sz;
        this.m33 *= sz;
        this.m34 *= sz;
    }

    public void setToScale(@Nonnull Vector3 s2) {
        this.setToScale(s2.x, s2.y, s2.z);
    }

    public void setToScale(float x, float y, float z) {
        this.setIdentity();
        this.m11 = x;
        this.m22 = y;
        this.m33 = z;
    }

    public void rotateX(float angle) {
        if (angle == 0.0f) {
            return;
        }
        float s2 = MathUtil.sin(angle);
        float c = MathUtil.cos(angle);
        float f21 = c * this.m21 + s2 * this.m31;
        float f22 = c * this.m22 + s2 * this.m32;
        float f23 = c * this.m23 + s2 * this.m33;
        float f24 = c * this.m24 + s2 * this.m34;
        this.m31 = -s2 * this.m21 + c * this.m31;
        this.m32 = -s2 * this.m22 + c * this.m32;
        this.m33 = -s2 * this.m23 + c * this.m33;
        this.m34 = -s2 * this.m24 + c * this.m34;
        this.m21 = f21;
        this.m22 = f22;
        this.m23 = f23;
        this.m24 = f24;
    }

    public void rotateY(float angle) {
        if (angle == 0.0f) {
            return;
        }
        float s2 = MathUtil.sin(angle);
        float c = MathUtil.cos(angle);
        float f11 = c * this.m11 - s2 * this.m31;
        float f12 = c * this.m12 - s2 * this.m32;
        float f13 = c * this.m13 - s2 * this.m33;
        float f14 = c * this.m14 - s2 * this.m34;
        this.m31 = s2 * this.m11 + c * this.m31;
        this.m32 = s2 * this.m12 + c * this.m32;
        this.m33 = s2 * this.m13 + c * this.m33;
        this.m34 = s2 * this.m14 + c * this.m34;
        this.m11 = f11;
        this.m12 = f12;
        this.m13 = f13;
        this.m14 = f14;
    }

    public void rotateZ(float angle) {
        if (angle == 0.0f) {
            return;
        }
        float s2 = MathUtil.sin(angle);
        float c = MathUtil.cos(angle);
        float f11 = c * this.m11 + s2 * this.m21;
        float f12 = c * this.m12 + s2 * this.m22;
        float f13 = c * this.m13 + s2 * this.m23;
        float f14 = c * this.m14 + s2 * this.m24;
        this.m21 = -s2 * this.m11 + c * this.m21;
        this.m22 = -s2 * this.m12 + c * this.m22;
        this.m23 = -s2 * this.m13 + c * this.m23;
        this.m24 = -s2 * this.m14 + c * this.m24;
        this.m11 = f11;
        this.m12 = f12;
        this.m13 = f13;
        this.m14 = f14;
    }

    public void rotateByAxis(@Nonnull Vector3 axis, float angle) {
        this.rotateByAxis(axis.x, axis.y, axis.z, angle);
    }

    public void rotateByAxis(float x, float y, float z, float angle) {
        if (angle == 0.0f || MathUtil.approxZero(x, y, z)) {
            return;
        }
        float f1 = MathUtil.sin(angle *= 0.5f);
        angle = MathUtil.cos(angle);
        x *= f1;
        y *= f1;
        z *= f1;
        f1 = 2.0f * x;
        float f2 = 2.0f * y;
        float f3 = 2.0f * z;
        float f4 = x * f1;
        float f5 = y * f2;
        float f6 = z * f3;
        float f7 = f3 * angle;
        float f8 = f2 * angle;
        float f9 = f1 * angle;
        float f11 = 1.0f - (f5 + f6);
        float f22 = 1.0f - (f4 + f6);
        float f33 = 1.0f - (f4 + f5);
        f2 *= x;
        x *= f3;
        f4 = f2 - f7;
        f5 = x + f8;
        f6 = f2 + f7;
        f7 = (f3 *= y) - f9;
        f8 = x - f8;
        f9 = f3 + f9;
        f1 = f11 * this.m11 + f6 * this.m21 + f8 * this.m31;
        f2 = f11 * this.m12 + f6 * this.m22 + f8 * this.m32;
        f3 = f11 * this.m13 + f6 * this.m23 + f8 * this.m33;
        x = f11 * this.m14 + f6 * this.m24 + f8 * this.m34;
        f11 = f4 * this.m11 + f22 * this.m21 + f9 * this.m31;
        f6 = f4 * this.m12 + f22 * this.m22 + f9 * this.m32;
        f8 = f4 * this.m13 + f22 * this.m23 + f9 * this.m33;
        y = f4 * this.m14 + f22 * this.m24 + f9 * this.m34;
        f4 = f5 * this.m11 + f7 * this.m21 + f33 * this.m31;
        f22 = f5 * this.m12 + f7 * this.m22 + f33 * this.m32;
        f9 = f5 * this.m13 + f7 * this.m23 + f33 * this.m33;
        z = f5 * this.m14 + f7 * this.m24 + f33 * this.m34;
        this.m11 = f1;
        this.m12 = f2;
        this.m13 = f3;
        this.m14 = x;
        this.m21 = f11;
        this.m22 = f6;
        this.m23 = f8;
        this.m24 = y;
        this.m31 = f4;
        this.m32 = f22;
        this.m33 = f9;
        this.m34 = z;
    }

    public void rotate(@Nonnull Quaternion q) {
        if (q.lengthSquared() >= 1.0E-6f) {
            this.multiply(q.toMatrix3());
        }
    }

    public void rotateByEuler(float rotationX, float rotationY, float rotationZ) {
        this.rotateX(rotationX);
        this.rotateY(rotationY);
        this.rotateZ(rotationZ);
    }

    public void transform(@Nonnull Vector4 vec) {
        float x = this.m11 * vec.x + this.m21 * vec.y + this.m31 * vec.z + this.m41 * vec.w;
        float y = this.m12 * vec.x + this.m22 * vec.y + this.m32 * vec.z + this.m42 * vec.w;
        float z = this.m13 * vec.x + this.m23 * vec.y + this.m33 * vec.z + this.m43 * vec.w;
        float w = this.m14 * vec.x + this.m24 * vec.y + this.m34 * vec.z + this.m44 * vec.w;
        vec.x = x;
        vec.y = y;
        vec.z = z;
        vec.w = w;
    }

    public void preTransform(@Nonnull Vector4 vec) {
        float x = this.m11 * vec.x + this.m12 * vec.y + this.m13 * vec.z + this.m14 * vec.w;
        float y = this.m21 * vec.x + this.m22 * vec.y + this.m23 * vec.z + this.m24 * vec.w;
        float z = this.m31 * vec.x + this.m32 * vec.y + this.m33 * vec.z + this.m34 * vec.w;
        float w = this.m41 * vec.x + this.m42 * vec.y + this.m43 * vec.z + this.m44 * vec.w;
        vec.x = x;
        vec.y = y;
        vec.z = z;
        vec.w = w;
    }

    public void transform(@Nonnull Vector3 vec) {
        float x = this.m11 * vec.x + this.m21 * vec.y + this.m31 * vec.z + this.m41;
        float y = this.m12 * vec.x + this.m22 * vec.y + this.m32 * vec.z + this.m42;
        float z = this.m13 * vec.x + this.m23 * vec.y + this.m33 * vec.z + this.m43;
        vec.x = x;
        vec.y = y;
        vec.z = z;
    }

    public void preTransform(@Nonnull Vector3 vec) {
        float x = this.m11 * vec.x + this.m12 * vec.y + this.m13 * vec.z + this.m14;
        float y = this.m21 * vec.x + this.m22 * vec.y + this.m23 * vec.z + this.m24;
        float z = this.m31 * vec.x + this.m32 * vec.y + this.m33 * vec.z + this.m34;
        vec.x = x;
        vec.y = y;
        vec.z = z;
    }

    public boolean isAffine() {
        return this.m14 == 0.0f && this.m24 == 0.0f && this.m34 == 0.0f && this.m44 == 1.0f;
    }

    public boolean hasPerspective() {
        return !this.isAffine();
    }

    public boolean hasTranslation() {
        return this.m41 != 0.0f || this.m42 != 0.0f || this.m43 != 0.0f || this.m44 != 1.0f;
    }

    public boolean isIdentity() {
        return MathUtil.approxZero(this.m12, this.m13, this.m14) && MathUtil.approxZero(this.m21, this.m23, this.m24) && MathUtil.approxZero(this.m31, this.m32, this.m34) && MathUtil.approxZero(this.m41, this.m42, this.m43) && MathUtil.approxEqual(this.m11, this.m22, this.m33, this.m44, 1.0f);
    }

    public boolean equivalent(@Nonnull Matrix4 mat) {
        if (this == mat) {
            return true;
        }
        return MathUtil.approxEqual(this.m11, mat.m11) && MathUtil.approxEqual(this.m12, mat.m12) && MathUtil.approxEqual(this.m13, mat.m13) && MathUtil.approxEqual(this.m14, mat.m14) && MathUtil.approxEqual(this.m21, mat.m21) && MathUtil.approxEqual(this.m22, mat.m22) && MathUtil.approxEqual(this.m23, mat.m23) && MathUtil.approxEqual(this.m24, mat.m24) && MathUtil.approxEqual(this.m31, mat.m31) && MathUtil.approxEqual(this.m32, mat.m32) && MathUtil.approxEqual(this.m33, mat.m33) && MathUtil.approxEqual(this.m34, mat.m34) && MathUtil.approxEqual(this.m41, mat.m41) && MathUtil.approxEqual(this.m42, mat.m42) && MathUtil.approxEqual(this.m43, mat.m43) && MathUtil.approxEqual(this.m44, mat.m44);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Matrix4 mat = (Matrix4)o;
        if (!MathUtil.exactlyEqual(mat.m11, this.m11)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m12, this.m12)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m13, this.m13)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m14, this.m14)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m21, this.m21)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m22, this.m22)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m23, this.m23)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m24, this.m24)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m31, this.m31)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m32, this.m32)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m33, this.m33)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m34, this.m34)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m41, this.m41)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m42, this.m42)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(mat.m43, this.m43)) {
            return false;
        }
        return MathUtil.exactlyEqual(mat.m44, this.m44);
    }

    public int hashCode() {
        int result = this.m11 != 0.0f ? Float.floatToIntBits(this.m11) : 0;
        result = 31 * result + (this.m12 != 0.0f ? Float.floatToIntBits(this.m12) : 0);
        result = 31 * result + (this.m13 != 0.0f ? Float.floatToIntBits(this.m13) : 0);
        result = 31 * result + (this.m14 != 0.0f ? Float.floatToIntBits(this.m14) : 0);
        result = 31 * result + (this.m21 != 0.0f ? Float.floatToIntBits(this.m21) : 0);
        result = 31 * result + (this.m22 != 0.0f ? Float.floatToIntBits(this.m22) : 0);
        result = 31 * result + (this.m23 != 0.0f ? Float.floatToIntBits(this.m23) : 0);
        result = 31 * result + (this.m24 != 0.0f ? Float.floatToIntBits(this.m24) : 0);
        result = 31 * result + (this.m31 != 0.0f ? Float.floatToIntBits(this.m31) : 0);
        result = 31 * result + (this.m32 != 0.0f ? Float.floatToIntBits(this.m32) : 0);
        result = 31 * result + (this.m33 != 0.0f ? Float.floatToIntBits(this.m33) : 0);
        result = 31 * result + (this.m34 != 0.0f ? Float.floatToIntBits(this.m34) : 0);
        result = 31 * result + (this.m41 != 0.0f ? Float.floatToIntBits(this.m41) : 0);
        result = 31 * result + (this.m42 != 0.0f ? Float.floatToIntBits(this.m42) : 0);
        result = 31 * result + (this.m43 != 0.0f ? Float.floatToIntBits(this.m43) : 0);
        result = 31 * result + (this.m44 != 0.0f ? Float.floatToIntBits(this.m44) : 0);
        return result;
    }

    public String toString() {
        return "Matrix4:\n" + this.m11 + ' ' + this.m12 + ' ' + this.m13 + ' ' + this.m14 + '\n' + this.m21 + ' ' + this.m22 + ' ' + this.m23 + ' ' + this.m24 + '\n' + this.m31 + ' ' + this.m32 + ' ' + this.m33 + ' ' + this.m34 + '\n' + this.m41 + ' ' + this.m42 + ' ' + this.m43 + ' ' + this.m44 + '\n';
    }

    @Nonnull
    public Matrix4 copy() {
        try {
            return (Matrix4)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private static void mulMatrix(@Nonnull float[] a, @Nonnull float[] b) {
        float var4 = b[0];
        float var5 = b[1];
        float var6 = b[2];
        float var7 = b[3];
        float var8 = b[4];
        float var9 = b[5];
        float var10 = b[6];
        float var11 = b[7];
        float var12 = b[8];
        float var13 = b[9];
        float var14 = b[10];
        float var15 = b[11];
        float var16 = b[12];
        float var17 = b[13];
        float var18 = b[14];
        float var19 = b[15];
        float var20 = a[0];
        float var21 = a[4];
        float var22 = a[8];
        float var23 = a[12];
        a[0] = var20 * var4 + var21 * var5 + var22 * var6 + var23 * var7;
        a[4] = var20 * var8 + var21 * var9 + var22 * var10 + var23 * var11;
        a[8] = var20 * var12 + var21 * var13 + var22 * var14 + var23 * var15;
        a[12] = var20 * var16 + var21 * var17 + var22 * var18 + var23 * var19;
        var20 = a[1];
        var21 = a[5];
        var22 = a[9];
        var23 = a[13];
        a[1] = var20 * var4 + var21 * var5 + var22 * var6 + var23 * var7;
        a[5] = var20 * var8 + var21 * var9 + var22 * var10 + var23 * var11;
        a[9] = var20 * var12 + var21 * var13 + var22 * var14 + var23 * var15;
        a[13] = var20 * var16 + var21 * var17 + var22 * var18 + var23 * var19;
        var20 = a[2];
        var21 = a[6];
        var22 = a[10];
        var23 = a[14];
        a[2] = var20 * var4 + var21 * var5 + var22 * var6 + var23 * var7;
        a[6] = var20 * var8 + var21 * var9 + var22 * var10 + var23 * var11;
        a[10] = var20 * var12 + var21 * var13 + var22 * var14 + var23 * var15;
        a[14] = var20 * var16 + var21 * var17 + var22 * var18 + var23 * var19;
        var20 = a[3];
        var21 = a[7];
        var22 = a[11];
        var23 = a[15];
        a[3] = var20 * var4 + var21 * var5 + var22 * var6 + var23 * var7;
        a[7] = var20 * var8 + var21 * var9 + var22 * var10 + var23 * var11;
        a[11] = var20 * var12 + var21 * var13 + var22 * var14 + var23 * var15;
        a[15] = var20 * var16 + var21 * var17 + var22 * var18 + var23 * var19;
    }

    private static void multiply(@Nonnull float[] a, @Nonnull float[] b, @Nonnull float[] out) {
        float[] temp = new float[28];
        float f11 = a[0] + a[10];
        float f12 = a[1] + a[11];
        float f21 = a[4] + a[14];
        float f22 = a[5] + a[15];
        float g11 = b[0] + b[10];
        float g12 = b[1] + b[11];
        float g21 = b[4] + b[14];
        float g22 = b[5] + b[15];
        float x1 = (f11 + f22) * (g11 + g22);
        float x2 = (f21 + f22) * g11;
        float x3 = f11 * (g12 - g22);
        float x4 = f22 * (g21 - g11);
        float x5 = (f11 + f12) * g22;
        float x6 = (f21 - f11) * (g11 + g12);
        float x7 = (f12 - f22) * (g21 + g22);
        temp[0] = x1 + x4 - x5 + x7;
        temp[1] = x3 + x5;
        temp[2] = x2 + x4;
        temp[3] = x1 - x2 + x3 + x6;
        f11 = a[8] + a[10];
        f12 = a[9] + a[11];
        f21 = a[12] + a[14];
        f22 = a[13] + a[15];
        g11 = b[0];
        g12 = b[1];
        g21 = b[4];
        g22 = b[5];
        x1 = (f11 + f22) * (g11 + g22);
        x2 = (f21 + f22) * g11;
        x3 = f11 * (g12 - g22);
        x4 = f22 * (g21 - g11);
        x5 = (f11 + f12) * g22;
        x6 = (f21 - f11) * (g11 + g12);
        x7 = (f12 - f22) * (g21 + g22);
        temp[4] = x1 + x4 - x5 + x7;
        temp[5] = x3 + x5;
        temp[6] = x2 + x4;
        temp[7] = x1 - x2 + x3 + x6;
        f11 = a[0];
        f12 = a[1];
        f21 = a[4];
        f22 = a[5];
        g11 = b[2] - b[10];
        g12 = b[3] - b[11];
        g21 = b[6] - b[14];
        g22 = b[7] - b[15];
        x1 = (f11 + f22) * (g11 + g22);
        x2 = (f21 + f22) * g11;
        x3 = f11 * (g12 - g22);
        x4 = f22 * (g21 - g11);
        x5 = (f11 + f12) * g22;
        x6 = (f21 - f11) * (g11 + g12);
        x7 = (f12 - f22) * (g21 + g22);
        temp[8] = x1 + x4 - x5 + x7;
        temp[9] = x3 + x5;
        temp[10] = x2 + x4;
        temp[11] = x1 - x2 + x3 + x6;
        f11 = a[10];
        f12 = a[11];
        f21 = a[14];
        f22 = a[15];
        g11 = b[10] - b[0];
        g12 = b[11] - b[1];
        g21 = b[12] - b[4];
        g22 = b[13] - b[5];
        x1 = (f11 + f22) * (g11 + g22);
        x2 = (f21 + f22) * g11;
        x3 = f11 * (g12 - g22);
        x4 = f22 * (g21 - g11);
        x5 = (f11 + f12) * g22;
        x6 = (f21 - f11) * (g11 + g12);
        x7 = (f12 - f22) * (g21 + g22);
        temp[12] = x1 + x4 - x5 + x7;
        temp[13] = x3 + x5;
        temp[14] = x2 + x4;
        temp[15] = x1 - x2 + x3 + x6;
        f11 = a[0] + a[2];
        f12 = a[1] + a[3];
        f21 = a[4] + a[6];
        f22 = a[5] + a[7];
        g11 = b[10];
        g12 = b[11];
        g21 = b[14];
        g22 = b[15];
        x1 = (f11 + f22) * (g11 + g22);
        x2 = (f21 + f22) * g11;
        x3 = f11 * (g12 - g22);
        x4 = f22 * (g21 - g11);
        x5 = (f11 + f12) * g22;
        x6 = (f21 - f11) * (g11 + g12);
        x7 = (f12 - f22) * (g21 + g22);
        temp[16] = x1 + x4 - x5 + x7;
        temp[17] = x3 + x5;
        temp[18] = x2 + x4;
        temp[19] = x1 - x2 + x3 + x6;
        f11 = a[10] - a[0];
        f12 = a[11] - a[1];
        f21 = a[12] - a[4];
        f22 = a[13] - a[5];
        g11 = b[0] + b[2];
        g12 = b[1] + b[3];
        g21 = b[4] + b[6];
        g22 = b[5] + b[7];
        x1 = (f11 + f22) * (g11 + g22);
        x2 = (f21 + f22) * g11;
        x3 = f11 * (g12 - g22);
        x4 = f22 * (g21 - g11);
        x5 = (f11 + f12) * g22;
        x6 = (f21 - f11) * (g11 + g12);
        x7 = (f12 - f22) * (g21 + g22);
        temp[20] = x1 + x4 - x5 + x7;
        temp[21] = x3 + x5;
        temp[22] = x2 + x4;
        temp[23] = x1 - x2 + x3 + x6;
        f11 = a[2] - a[10];
        f12 = a[3] - a[11];
        f21 = a[6] - a[14];
        f22 = a[7] - a[15];
        g11 = b[8] + b[10];
        g12 = b[9] + b[11];
        g21 = b[12] + b[14];
        g22 = b[13] + b[15];
        x1 = (f11 + f22) * (g11 + g22);
        x2 = (f21 + f22) * g11;
        x3 = f11 * (g12 - g22);
        x4 = f22 * (g21 - g11);
        x5 = (f11 + f12) * g22;
        x6 = (f21 - f11) * (g11 + g12);
        x7 = (f12 - f22) * (g21 + g22);
        temp[24] = x1 + x4 - x5 + x7;
        temp[25] = x3 + x5;
        temp[26] = x2 + x4;
        temp[27] = x1 - x2 + x3 + x6;
        out[0] = temp[0] + temp[12] - temp[16] + temp[24];
        out[1] = temp[1] + temp[13] - temp[17] + temp[25];
        out[4] = temp[2] + temp[14] - temp[18] + temp[26];
        out[5] = temp[3] + temp[15] - temp[19] + temp[27];
        out[2] = temp[8] + temp[16];
        out[3] = temp[9] + temp[17];
        out[6] = temp[10] + temp[18];
        out[7] = temp[11] + temp[19];
        out[8] = temp[4] + temp[12];
        out[9] = temp[5] + temp[13];
        out[12] = temp[6] + temp[14];
        out[13] = temp[7] + temp[15];
        out[10] = temp[0] - temp[4] + temp[8] + temp[20];
        out[11] = temp[1] - temp[5] + temp[9] + temp[21];
        out[14] = temp[2] - temp[6] + temp[10] + temp[22];
        out[15] = temp[3] - temp[7] + temp[11] + temp[23];
    }
}

